<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
<xsl:output method="html"/>
<xsl:decimal-format name="getal" decimal-separator="," grouping-separator="."/>
<xsl:template match="/">
	<html>
	<head>
		<title>Overzicht Normen Vtlb</title>
		<style>
		h1 {font-style: normal; font-weight: bold; font-size:12pt; font-family:Verdana; color:Darkblue}
		h2 {font-style: normal; font-weight: bold; font-size:8pt; font-family:Verdana; color:Darkblue; display:inline}
		h3 {font-style: normal; font-weight: bold; font-size:9pt; font-family:Verdana; color:Black; display:inline}
		h4 {font-style: normal; font-weight: normal; font-size:8pt; font-family:Verdana; color:Black; display:inline}
		h5 {font-style: normal; font-weight: normal; font-size:8pt; font-family:Verdana; color:Black}
		h6 {font-style: normal; font-weight: bold; font-size:10pt; font-family:WingDings; color:Black; display:inline}
		</style>
	</head>
	<body>
		<style>
		@media print {DIV.PAGEBREAK {page-break-before: always; page-break-inside: auto; orphans:1; widows:1}} 
		</style>
		<table cellSpacing="0" width="100%" align="left">
			<tbody>
				<tr>
					<td width="100%">
						<h1 align="center">Overzicht Normen Vtlb</h1>
					</td>
				</tr>
				<tr>
					<td width="100%">
						<h5 align="center">Versie <xsl:value-of select="VTLBNormen/Algemeen/Plug-in/Versienummer"/>.<xsl:value-of select="VTLBNormen/Algemeen/Plug-in/Releasenummer"/></h5>
					</td>
				</tr>
			</tbody>
		</table>
		<p><br clear="left"/></p>
		<table cellSpacing="0" width="100%" align="left">
			<tbody>
				<tr>
					<td width="58%">
						<h4>Berekeningsversie </h4>&#160;
						<h4><xsl:call-template name="maakDatum"><xsl:with-param name="datum" select="VTLBNormen/Algemeen/Plug-in/Ingangsdatum"/></xsl:call-template></h4>
					</td>
					<td width="40%" align="right">
						<h4>Overzicht gemaakt op </h4>&#160;
						<h4><xsl:call-template name="maakDatum"><xsl:with-param name="datum" select="VTLBNormen/Algemeen/Datum"/></xsl:call-template></h4>
					</td>
					<td width="02%"/>
				</tr>
			</tbody>
		</table>
		<p><br clear="left"/></p>
		<table cellSpacing="0" width="100%" align="left">
			<tbody>
				<tr>
					<td width="29%">&#160;</td>
					<td width="29%"/>
					<td width="20%"/>
					<td width="20%"/>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="29%">
						<h3>Normen Participatiewet</h3>
					</td>
					<td width="20%" align="right">
						<h4><strong>Bedrag</strong></h4>
					</td>
					<td width="20%" align="right">
						<h4><strong>Vakantiegeld</strong></h4>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="29%">
						<h4>Percentage vakantiegeld</h4>&#160;&#160;
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Percentage_Vak"/></xsl:call-template></h2>
						<h4>&#160;%</h4>
					</td>
					<td width="20%" align="right"/>
					<td width="20%" align="right">
						<h4>(indien excl.)</h4>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="29%">
						<h4>(Echt)paar</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Echtpaar/Bedrag"/></xsl:call-template></h2>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Echtpaar/Vakantiegeld"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="29%">
						<h4>Alleenstaande (ouder)</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Alleenstaande/Bedrag"/></xsl:call-template></h2>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Alleenstaande/Vakantiegeld"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="29%">
						<h4>(Echt)paar beide pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Echtpaar_Beide_65/Bedrag"/></xsl:call-template></h2>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Echtpaar_Beide_65/Vakantiegeld"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="29%">
						<h4>(Echt)paar een pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Echtpaar_Een_65/Bedrag"/></xsl:call-template></h2>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Echtpaar_Een_65/Vakantiegeld"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="29%">
						<h4>Alleenstaande (ouder) pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Alleenstaande_Pensioengerechtigd/Bedrag"/></xsl:call-template></h2>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Alleenstaande_Pensioengerechtigd/Vakantiegeld"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="29%">
						<h4>(Echt)paar in een inrichting</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Samen_Inrichting"/></xsl:call-template></h2>
					</td>
					<td width="20%" align="right"/>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="29%">
						<h4>Alleenstaande (ouder) in een inrichting</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_WWB/Alleen_Inrichting"/></xsl:call-template></h2>
					</td>
					<td width="20%" align="right"/>
					<td width="02%"/>
				</tr>
			</tbody>
		</table>
		<p><br clear="left"/></p>
		<table cellSpacing="0" width="100%" align="left">
			<tbody>
				<tr>
					<td width="39%"></td>
					<td width="39%"/>
					<td width="20%"/>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h3>Normen i.v.m. wonen</h3>
					</td>
					<td width="20%" align="right">
						<h4><strong>Bedrag</strong></h4>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Huurtoeslag - maximale huurgrens</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/MaxGrens"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Huurtoeslag - maximale huurgrens jongeren onder 21</h4>
					</td>
					<!-- m*5.0 MaxGrens_23 is sinds versie 5.0 MaxGrens_21 -->
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/MaxGrens_23"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Huurtoeslag - ondergrens</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Ondergrens"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Huurtoeslag - ondergrens eenpersoonshuishouden pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Ondergrens_Een_65"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Huurtoeslag - ondergrens meerpersoonshuishouden pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Ondergrens_Meer_65"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<!--m*4.0.1
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging eenpersoonshuishouden</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Een"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging tweepersoonshuishouden</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Twee"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging meerpersoonshuishouden</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Meer"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging eenpersoonshuishouden jonger 23</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Een_23"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging tweepersoonshuishouden jonger 23</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Twee_23"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging meerpersoonshuishouden jonger 23</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Meer_23"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging eenpersoonshuishouden pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Een_65"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging tweepersoonshuish., 1 (minst-verdienende) pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Twee_65_Een"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging tweepersoonshuish., beide of meest-verdienende pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Twee_65_Beide"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging meerpersoonshuish., 1 (niet meest-verdienende) pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Meer_65_Minst"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max. verhoging meerpersoonshuish., 1 (meest-verdienende) pensioengerechtigd</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Verhoging_Meer_65_Meest"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				-->
				<tr>
					<td colSpan="2" width="39%">
						<h4>Correctie woonlasten - maximale servicekosten</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Service"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Correctie woonlasten - overige kosten eigen woning - percentage WOZ-waarde</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag2"><xsl:with-param name="bedrag2" select="VTLBNormen/Normen_Wonen/Eigen_Woning"/></xsl:call-template></h2>
					</td>
					<td width="02%" align="left"><h4>&#160;%</h4></td>
				</tr>
				<!-- m*4.2.1 N.21.000.059
				<tr>
					<td colSpan="2" width="39%">
						<h4>Kostgangers - bedrag per dag</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Wonen/Kostgangers"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				-->
				<tr>
					<td colSpan="2" width="39%">
						<h3>Normen i.v.m. zorgverzekering</h3>
					</td>
					<td width="20%" align="right"/>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Standaard normpremie alleenstaande</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Zorg/Alleen_Zorg"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Standaard normpremie (echt)paar</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Zorg/Echtpaar_Zorg"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Verplicht eigen risico per jaar</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Zorg/Eigen_Risico"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>

				<tr>
					<td colSpan="2" width="39%">
						<h3>Normen i.v.m. studiekosten</h3>
					</td>
					<td width="20%" align="right"/>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Basiscorrectie kind ouder of gelijk 18 VO</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Studie/Basis_Boven_18_VO"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Correctie kind ouder of gelijk 18 VO Onderbouw</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Studie/Boven_18_VOO"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Correctie kind ouder of gelijk 18 VO Bovenbouw</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Studie/Boven_18_VOB"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<!--m*4.0.1 Nieuw -->
				<tr>
					<td colSpan="2" width="39%">
						<h3>Normen i.v.m. beslagvrije voet</h3>
					</td>
					<td width="20%" align="right"/>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Drempelbedrag huurwoning waarde</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Drempel_huurwoning"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<!--m*4.5.1 Nieuw -->
				<tr>
					<td colSpan="2" width="39%">
						<h4>Duur tijdelijke ophoging woonkosten in de beslagvrije voet </h4>
						<h2><xsl:call-template name="maakNummer"><xsl:with-param name="nummer" select="VTLBNormen/Normen_BVV/Duur_Tijdelijke_Ophoging"/></xsl:call-template></h2>
						<h4> maanden</h4>
					</td>
					<td width="20%" align="right"/>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max BVV alleenstaand zonder kinderen (belastbaar inkomen tussen </h4>
						<h2><xsl:call-template name="maakBedrag0"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Min_beslastbaarinkomen_voor_Max_BVV_Alleen"/></xsl:call-template></h2><h4> en </h4>
                        <h2><xsl:call-template name="maakBedrag0"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Max_beslastbaarinkomen_voor_Max_BVV_Alleen"/></xsl:call-template></h2><h4>) </h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Max_BVV_Alleen"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max BVV alleenstaand met kinderen (belastbaar inkomen tussen </h4>
						<h2><xsl:call-template name="maakBedrag0"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Min_beslastbaarinkomen_voor_Max_BVV_Alleen_ouder"/></xsl:call-template></h2><h4> en </h4>
						<h2><xsl:call-template name="maakBedrag0"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Max_beslastbaarinkomen_voor_Max_BVV_Alleen_ouder"/></xsl:call-template></h2><h4>) </h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Max_BVV_Alleen_Ouder"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max BVV gehuwd zonder kinderen (belastbaar inkomen tussen </h4>
						<h2><xsl:call-template name="maakBedrag0"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Min_beslastbaarinkomen_voor_Max_BVV_Echtpaar_Zonder_Kind"/></xsl:call-template></h2><h4> en </h4>
						<h2><xsl:call-template name="maakBedrag0"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Max_beslastbaarinkomen_voor_Max_BVV_Echtpaar_Zonder_Kind"/></xsl:call-template></h2><h4>) </h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Max_BVV_Echtpaar_Zonder_Kind"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Max BVV gehuwd met kinderen (belastbaar inkomen tussen </h4>
						<h2><xsl:call-template name="maakBedrag0"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Min_beslastbaarinkomen_voor_Max_BVV_Echtpaar_Met_Kind"/></xsl:call-template></h2><h4> en </h4>
						<h2><xsl:call-template name="maakBedrag0"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Max_beslastbaarinkomen_voor_Max_BVV_Echtpaar_Met_Kind"/></xsl:call-template></h2><h4>) </h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_BVV/Max_BVV_Echtpaar_Met_Kind"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>

				<tr>
					<td colSpan="2" width="39%">
						<h3>Normen overig</h3>
					</td>
					<td width="20%" align="right"/>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Kindgebonden budget  - maximum bedrag per maand - 1e kind</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/KindgebondenBudget_Kind1"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Kindgebonden budget  - maximum bedrag per maand - 2e kind</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/KindgebondenBudget_Kind2"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Kindgebonden budget  - maximum bedrag per maand - 3e kind</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/KindgebondenBudget_Kind3"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Kindgebonden budget  - maximum bedrag per maand - 4e kind</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/KindgebondenBudget_Kind4"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Kindgebonden budget  - maximum bedrag per maand - 5e (e.v.) kind(eren)</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/KindgebondenBudget_Kind5"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Kindgebonden budget  - verhoging per maand per kind vanaf 12 jaar</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/KindgebondenBudget_Vanaf12"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Kindgebonden budget  - verhoging per maand per kind vanaf 16 jaar</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/KindgebondenBudget_Vanaf16"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Kindgebonden budget  - maximale alleenstaande ouderkop</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/KindgebondenBudget_Max_Alleen_Ouderkop"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Eigen auto - basiscorrectie</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Auto/Basis"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Eigen auto - bedrag/km</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag2"><xsl:with-param name="bedrag2" select="VTLBNormen/Normen_Auto/Bedrag_Km"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Eigen auto - omslagpunt kilometrage </h4>
						<h2><xsl:call-template name="maakNummer"><xsl:with-param name="nummer" select="VTLBNormen/Normen_Auto/Omslagpunt_Km"/></xsl:call-template></h2>
						<h4> km</h4>
					</td>
					<td width="20%" align="right"/>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Arbeidstoeslag</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/Arbeidstoeslag"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Vergoeding int. chauffeurs</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/Vergoeding_vrachtwagenchauffeurs"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
				<tr>
					<td colSpan="2" width="39%">
						<h4>Rekenfactor vakantietoeslag</h4>
					</td>
					<td width="20%" align="right">
						<h2><xsl:call-template name="maakBedrag"><xsl:with-param name="bedrag" select="VTLBNormen/Normen_Divers/Rekenfactor_vakantietoeslag"/></xsl:call-template></h2>
					</td>
					<td width="02%"/>
				</tr>
			</tbody>
		</table>
	</body>
	</html>
</xsl:template>
<xsl:template name="maakDatum"><xsl:param name="datum"/><xsl:param name="Jaar" select="substring($datum,1,4)"/><xsl:param name="Maand" select="substring($datum,6,2)"/><xsl:param name="Dag" select="substring($datum,9,2)"/>
	<xsl:value-of select="$Dag"/>
	<xsl:if test="$Dag&gt;0">
		<xsl:text>-</xsl:text>
	</xsl:if>
	<xsl:value-of select="$Maand"/>
	<xsl:if test="$Maand&gt;0">
		<xsl:text>-</xsl:text>
	</xsl:if>
	<xsl:if test="$Jaar&gt;0">
		<xsl:value-of select="$Jaar"/>
	</xsl:if>
</xsl:template>
<xsl:template name="maakBedrag0">
      <xsl:param name="bedrag"/><xsl:param name="temp" select="translate($bedrag,',','.')"/>
	<xsl:if test="string-length($bedrag)&gt;0">
		<xsl:if test="$bedrag!=' '">
			<xsl:if test="$bedrag!='&#x0A;'">
					<xsl:value-of select="format-number($temp,'#.##0;-#.##0','getal')"/>
			</xsl:if>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="maakBedrag">
      <xsl:param name="bedrag"/><xsl:param name="temp" select="translate($bedrag,',','.')"/>
	<xsl:if test="string-length($bedrag)&gt;0">
		<xsl:if test="$bedrag!=' '">
			<xsl:if test="$bedrag!='&#x0A;'">
					<xsl:value-of select="format-number($temp,'#.##0,00;-#.##0,00','getal')"/>
			</xsl:if>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="maakBedrag2">
      <xsl:param name="bedrag2"/><xsl:param name="temp" select="translate($bedrag2,',','.')"/>
	<xsl:if test="string-length($bedrag2)&gt;0">
		<xsl:if test="$bedrag2!=' '">
			<xsl:if test="$bedrag2!='&#x0A;'">
					<xsl:value-of select="format-number($temp,'#.##0,000;-#.##0,000','getal')"/>
			</xsl:if>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="maakBedrag3">
      <xsl:param name="bedrag3"/><xsl:param name="temp" select="translate($bedrag3,',','.')"/>
	<xsl:if test="string-length($bedrag3)&gt;0">
		<xsl:if test="$bedrag3!=' '">
			<xsl:if test="$bedrag3!='&#x0A;'">
					<xsl:value-of select="format-number($temp,'#.##0,0000;-#.##0,0000','getal')"/>
			</xsl:if>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="maakNummer">
 <xsl:param name="nummer"/>
 <xsl:value-of select="format-number($nummer,'#.###.##0;-#.###.##0','getal')"/>
 </xsl:template>
<xsl:template name="maakPostcode"><xsl:param name="postcode"/>
	<xsl:value-of select="substring($postcode,1,4)"/>
	<xsl:text><![CDATA[ ]]></xsl:text>
	<xsl:value-of select="substring($postcode,5,2)"/>
</xsl:template>
</xsl:stylesheet>
